<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Completion extends Model
{
    use HasFactory;

    protected $primaryKey = 'completions_id';

    public $timestamps = false;

    protected $fillable = [
        'service_id',
        'user_id',
        'charged',
        'date',
        'notes',
        'approved',
    ];

    protected function casts(): array
    {
        return [
            'charged' => 'decimal:2',
            'date' => 'datetime',
            'approved' => 'boolean',
            'created_at' => 'datetime',
        ];
    }

    // Relationships
    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'service_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function commission()
    {
        return $this->hasOne(Commission::class, 'completions_id', 'completions_id');
    }
}
