<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Service extends Model
{
    use HasFactory;

    protected $primaryKey = 'service_id';

    public $timestamps = false;

    protected $fillable = [
        'service_department',
        'service_name',
        'price',
        'commission',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'price' => 'decimal:2',
            'commission' => 'decimal:2',
            'is_active' => 'boolean',
            'created_at' => 'datetime',
        ];
    }

    // Relationships
    public function completions()
    {
        return $this->hasMany(Completion::class, 'service_id', 'service_id');
    }
}
