<?php

namespace App\Observers;

use App\Models\Signin;
use Carbon\Carbon;

class SigninObserver
{
    /**
     * Handle the Signin "creating" event.
     * Adjust timestamps with timezone (+7 hours).
     */
    public function creating(Signin $signin): void
    {
        if ($signin->created_at) {
            $signin->created_at = Carbon::parse($signin->created_at)->addHours(7);
        }

        if ($signin->updated_at) {
            $signin->updated_at = Carbon::parse($signin->updated_at)->addHours(7);
        }
    }

    /**
     * Handle the Signin "updating" event.
     * Adjust updated_at timestamp with timezone (+7 hours).
     */
    public function updating(Signin $signin): void
    {
        if ($signin->updated_at) {
            $signin->updated_at = Carbon::parse($signin->updated_at)->addHours(7);
        }
    }
}
