<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table): void {
            $table->increments('payment_id');
            $table->integer('user_id');
            $table->decimal('amount', 10, 2);
            $table->date('payment_date')->default(DB::raw('CURRENT_DATE'));
            $table->text('description')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();

            $table->index('user_id', 'idx_payments_user');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
