<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('description')->nullable();
            $table->string('icon')->nullable();
            $table->string('color')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });

        // Insert default categories
        DB::table('categories')->insert([
            ['name' => 'Hair Products', 'description' => 'Shampoos, conditioners, treatments', 'icon' => 'hair', 'color' => '#E91E63', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Nail Care', 'description' => 'Polish, tools, treatments', 'icon' => 'nail', 'color' => '#9C27B0', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Skin Care', 'description' => 'Creams, lotions, treatments', 'icon' => 'face', 'color' => '#FF9800', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Makeup', 'description' => 'Cosmetics and beauty products', 'icon' => 'makeup', 'color' => '#F44336', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Tools & Equipment', 'description' => 'Professional salon tools', 'icon' => 'tools', 'color' => '#607D8B', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Spa Products', 'description' => 'Massage oils, aromatherapy', 'icon' => 'spa', 'color' => '#4CAF50', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Cleaning Supplies', 'description' => 'Sanitizers, disinfectants', 'icon' => 'clean', 'color' => '#2196F3', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Accessories', 'description' => 'Combs, brushes, clips', 'icon' => 'accessories', 'color' => '#00BCD4', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Retail Products', 'description' => 'Products for resale', 'icon' => 'retail', 'color' => '#FFC107', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
            ['name' => 'Other', 'description' => 'Miscellaneous items', 'icon' => 'other', 'color' => '#9E9E9E', 'status' => 'active', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
