<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->string('sale_number')->unique();
            $table->integer('user_id'); // cashier
            $table->integer('customer_id')->nullable();

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->foreign('customer_id')->references('user_id')->on('users')->onDelete('set null');

            // Sale totals
            $table->decimal('subtotal', 12, 2);
            $table->decimal('tax_amount', 10, 2)->default(0);
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->decimal('total_amount', 12, 2);

            // Payment info
            $table->enum('payment_method', ['cash', 'card', 'mobile_money', 'bank_transfer', 'credit'])->default('cash');
            $table->decimal('amount_paid', 12, 2);
            $table->decimal('change_amount', 10, 2)->default(0);
            $table->enum('payment_status', ['pending', 'completed', 'refunded', 'cancelled'])->default('completed');

            // Additional info
            $table->text('notes')->nullable();
            $table->string('receipt_number')->nullable();
            $table->timestamp('sale_date');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
