<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ExpensesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = DB::table('users')->pluck('user_id')->toArray();
        
        if (empty($users)) {
            $this->command->warn('No users found. Please run UsersSeeder first.');
            return;
        }

        $expenses = [];
        
        // Create 15 sample expenses over the past 2 months
        for ($i = 0; $i < 15; $i++) {
            $expenseDate = now()->subDays(rand(0, 60));
            
            $expenses[] = [
                'admin_id' => $users[array_rand($users)],
                'expense_date' => $expenseDate->format('Y-m-d'),
                'amount' => rand(5000, 100000),
                'description' => $this->generateDescription(),
                'created_at' => $expenseDate,
                'updated_at' => $expenseDate,
            ];
        }

        foreach ($expenses as $expense) {
            DB::table('expenses')->insert($expense);
        }
        
        $this->command->info('Successfully seeded ' . count($expenses) . ' expenses.');
    }
    
    private function generateDescription(): string
    {
        $descriptions = [
            'Monthly shop rent payment',
            'Electricity and water bills',
            'Office and cleaning supplies',
            'Social media advertising campaign',
            'Equipment maintenance and repairs',
            'Staff salary payment',
            'Fuel and transportation costs',
            'Business insurance premium',
            'Office furniture purchase',
            'Marketing materials printing',
            'Internet and phone bills',
            'Professional services fee',
            'Cleaning services',
            'Security services',
            'Business license renewal',
        ];
        
        return $descriptions[array_rand($descriptions)];
    }
}
