<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;

class ServicesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            // Kinyozi (Barber) Services
            ['service_department' => 'Kinyozi', 'service_name' => 'Haircut', 'price' => 800.00, 'commission' => 50.00],
            ['service_department' => 'Kinyozi', 'service_name' => 'Hair Color', 'price' => 500.00, 'commission' => 40.00],
            ['service_department' => 'Kinyozi', 'service_name' => 'Hair Dye', 'price' => 300.00, 'commission' => 40.00],
            ['service_department' => 'Kinyozi', 'service_name' => 'Beards', 'price' => 100.00, 'commission' => 50.00],
            ['service_department' => 'Kinyozi', 'service_name' => 'Beards Dye', 'price' => 600.00, 'commission' => 40.00],
            ['service_department' => 'Kinyozi', 'service_name' => 'Massage Head', 'price' => 300.00, 'commission' => 40.00],

            // SPA Services
            ['service_department' => 'SPA', 'service_name' => 'Manicure', 'price' => 500.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Pedicure', 'price' => 700.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Facial', 'price' => 1200.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Waxing', 'price' => 400.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Nails Undoing', 'price' => 300.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Acrylic Nails', 'price' => 800.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Plain Gel', 'price' => 600.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Tips Gel', 'price' => 700.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Gum Gel', 'price' => 500.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Massage Full', 'price' => 1000.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Massage Half', 'price' => 500.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Facial Scrub', 'price' => 400.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Brazilian Wax', 'price' => 800.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Armpit Wax', 'price' => 350.00, 'commission' => 40.00],
            ['service_department' => 'SPA', 'service_name' => 'Nail repair', 'price' => 100.00, 'commission' => 40.00],
            ['service_department' => 'Spa', 'service_name' => 'nail cutting', 'price' => 100.00, 'commission' => 40.00],
            ['service_department' => 'Spa', 'service_name' => 'steaming', 'price' => 300.00, 'commission' => 40.00],

            // Salon Services
            ['service_department' => 'Salon', 'service_name' => 'Hair Undoing', 'price' => 400.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Ghanian Hair', 'price' => 900.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Twistout', 'price' => 450.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Treatment', 'price' => 350.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'Own Treatment', 'price' => 200.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'wash and dry', 'price' => 200.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'lines', 'price' => 200.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Wash', 'price' => 150.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'braiding', 'price' => 1000.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Retouch', 'price' => 800.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'Eyebrows', 'price' => 100.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Lashes', 'price' => 800.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'Sales', 'price' => 70.00, 'commission' => 0.00],
            ['service_department' => 'Salon', 'service_name' => 'kids braids', 'price' => 150.00, 'commission' => 50.00],
            ['service_department' => 'Salon', 'service_name' => 'weave straightning', 'price' => 300.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'dry', 'price' => 150.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'own chemical', 'price' => 400.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'steaming', 'price' => 300.00, 'commission' => 40.00],
            ['service_department' => 'Salon', 'service_name' => 'oiling', 'price' => 100.00, 'commission' => 40.00],
        ];

        foreach ($services as $service) {
            Service::create(array_merge($service, [
                'is_active' => true,
            ]));
        }
    }
}
