<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>FAQs - Beauty Bawl</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:from-gray-900 dark:to-gray-900 text-gray-900 dark:text-gray-100">
        @include('partials.header')
        <main class="max-w-4xl mx-auto px-4 py-12">
            <h1 class="text-5xl font-bold text-center mb-6">Frequently Asked Questions</h1>
            <p class="text-center text-xl text-gray-600 dark:text-gray-400 mb-12">Find answers to common questions</p>

            <div class="space-y-4">
                @php
                $faqs = [
                    ['q' => 'How long does shipping take?', 'a' => 'Standard shipping takes 3-5 business days. Express shipping delivers in 1-2 business days. Free shipping on orders over $50!'],
                    ['q' => 'What payment methods do you accept?', 'a' => 'We accept all major credit/debit cards via Stripe, and M-Pesa for customers in Kenya. All payments are secure and encrypted.'],
                    ['q' => 'Are your products safe for sensitive skin?', 'a' => 'Yes! We carefully curate products that are gentle and family-safe. Each product listing includes ingredient information and suitability details.'],
                    ['q' => 'Can I return a product if I don\'t like it?', 'a' => 'Absolutely! We offer a 30-day return policy. Return any unused product in original packaging for a full refund or exchange.'],
                    ['q' => 'Do you ship internationally?', 'a' => 'Yes, we ship to Kenya, East Africa, and select international destinations. International shipping takes 7-14 business days.'],
                    ['q' => 'How can I track my order?', 'a' => 'Once your order ships, you\'ll receive a tracking number via email. Use this to track your package in real-time.'],
                    ['q' => 'Are your products cruelty-free?', 'a' => 'We prioritize cruelty-free and eco-conscious brands. Look for the eco-friendly badge on product pages.'],
                    ['q' => 'What if I receive a damaged product?', 'a' => 'Contact us immediately with photos. We\'ll send a replacement at no cost or issue a full refund - your choice.'],
                    ['q' => 'Do you offer gift wrapping?', 'a' => 'Yes! Select gift wrapping at checkout for a small fee. Perfect for birthdays, holidays, and special occasions.'],
                    ['q' => 'How do I contact customer service?', 'a' => 'Email us at support@beautybawl.com or call +254 700 000 000 (Mon-Fri, 9AM-6PM EAT). We respond within 24 hours.']
                ];
                @endphp

                @foreach($faqs as $index => $faq)
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg overflow-hidden">
                    <button class="w-full p-6 text-left flex items-center justify-between hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors" onclick="this.nextElementSibling.classList.toggle('hidden')">
                        <span class="font-bold text-lg pr-8">{{ $faq['q'] }}</span>
                        <svg class="w-6 h-6 text-pink-600 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                        </svg>
                    </button>
                    <div class="hidden px-6 pb-6 text-gray-600 dark:text-gray-400">
                        {{ $faq['a'] }}
                    </div>
                </div>
                @endforeach
            </div>

            <div class="mt-12 bg-gradient-to-r from-pink-600 to-purple-600 rounded-2xl p-8 text-center text-white">
                <h2 class="text-2xl font-bold mb-4">Still have questions?</h2>
                <p class="mb-6">We're here to help!</p>
                <a href="{{ url('/contact') }}" class="inline-block px-8 py-4 bg-white text-pink-600 rounded-full font-bold hover:scale-105 transition-transform">Contact Us</a>
            </div>
        </main>
        @include('partials.footer')
    </body>
</html>
