<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Returns & Refunds - Beauty Bawl</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:from-gray-900 dark:to-gray-900 text-gray-900 dark:text-gray-100">
        @include('partials.header')
        <main class="max-w-4xl mx-auto px-4 py-12">
            <h1 class="text-5xl font-bold mb-6">Returns & Refunds</h1>
            <p class="text-xl text-gray-600 dark:text-gray-400 mb-12">Shop with confidence - we've got you covered</p>

            <div class="space-y-8">
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">30-Day Return Policy</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Not satisfied? Return any unused product within 30 days of delivery for a full refund or exchange. Items must be in original packaging and unused.</p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">How to Return</h2>
                    <ol class="list-decimal list-inside space-y-3 text-gray-600 dark:text-gray-400">
                        <li>Contact our support team at support@beautybawl.com</li>
                        <li>Receive your return authorization and shipping label</li>
                        <li>Pack items securely in original packaging</li>
                        <li>Ship using the provided label (free return shipping)</li>
                        <li>Receive your refund within 5-7 business days</li>
                    </ol>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">Refund Processing</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Once we receive your return, refunds are processed within 2-3 business days. The refund will be credited to your original payment method (Stripe or M-Pesa).</p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">Damaged or Defective Items</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Received a damaged product? Contact us immediately with photos. We'll send a replacement at no cost or issue a full refund - your choice.</p>
                </div>

                <div class="bg-gradient-to-r from-pink-600 to-purple-600 rounded-2xl p-8 text-white text-center">
                    <h2 class="text-2xl font-bold mb-4">Questions about returns?</h2>
                    <p class="mb-6">Our customer service team is here to help</p>
                    <a href="{{ url('/contact') }}" class="inline-block px-8 py-4 bg-white text-pink-600 rounded-full font-bold hover:scale-105 transition-transform">Contact Support</a>
                </div>
            </div>
        </main>
        @include('partials.footer')
    </body>
</html>
