<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\ServiceController;
use App\Http\Controllers\Api\CompletionController;
use App\Http\Controllers\Api\CommissionController;
use App\Http\Controllers\Api\ExpenseController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\SigninController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\SalesController;
use Illuminate\Support\Facades\Route;

// Modern RESTful API routes
Route::prefix('v1')->group(function () {
    // Authentication
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/register', [AuthController::class, 'register']);

    // Users
    Route::get('users/trashed', [UserController::class, 'trashed']);
    Route::post('users/{id}/restore', [UserController::class, 'restore']);
    Route::delete('users/{id}/force', [UserController::class, 'forceDelete']);
    Route::apiResource('users', UserController::class);

    // Services
    Route::apiResource('services', ServiceController::class);

    // Completions
    Route::apiResource('completions', CompletionController::class);

    // Commissions
    Route::get('commissions/summary', [CommissionController::class, 'summary']);
    Route::get('commissions/top-earners', [CommissionController::class, 'topEarners']);
    Route::apiResource('commissions', CommissionController::class)->only(['index', 'show']);

    // Expenses
    Route::apiResource('expenses', ExpenseController::class);

    // Payments
    Route::apiResource('payments', PaymentController::class);

    // Signins
    Route::apiResource('signins', SigninController::class);

    // POS - Suppliers
    Route::get('suppliers/active', [SupplierController::class, 'active']);
    Route::apiResource('suppliers', SupplierController::class);

    // POS - Inventory
    Route::get('inventory/statistics', [InventoryController::class, 'statistics']);
    Route::get('inventory/alerts', [InventoryController::class, 'alerts']);
    Route::get('inventory/categories', [InventoryController::class, 'categories']);
    Route::post('inventory/categories', [InventoryController::class, 'storeCategory']);
    Route::put('inventory/categories/{id}', [InventoryController::class, 'updateCategory']);
    Route::delete('inventory/categories/{id}', [InventoryController::class, 'destroyCategory']);
    Route::post('inventory/{id}/update-stock', [InventoryController::class, 'updateStock']);
    Route::apiResource('inventory', InventoryController::class);

    // POS - Sales
    Route::get('sales/analytics', [SalesController::class, 'analytics']);
    Route::get('sales/summary', [SalesController::class, 'summary']);
    Route::post('sales/{id}/refund', [SalesController::class, 'refund']);
    Route::apiResource('sales', SalesController::class);
});
